//
//  CeResultSet.h
//  CeSQLiteConnect
//
//  Copyright 2006 __Cutedge Pte Ltd__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "sqlite3.h"

@interface CeResultSet : NSObject 
{
	char			**_result;
	int				_resultRows;
	int				_resultColumns;
	int				_columnCount;
	
	sqlite3_stmt	*_stmtHandler;
}
 
+ (id)resultSet:(char **)result forStmtHandler:(sqlite3_stmt *)stmtHandler withRows:(int)resultRows andColumns:(int)resultColumns;
- (void)close;
- (BOOL)next;

- (NSString *)fieldTypeAtIndex:(int)index;
- (NSString *)fieldNameAtIndex:(int)index;
- (id)fieldAtIndex:(int)index;
- (NSString *)stringAtIndex:(int)index;
- (int)intAtIndex:(int)index;
- (id)convertField:(sqlite3_stmt *)stmtHandler atIndex:(int)index;

- (NSArray *)fieldTypes;
- (NSArray *)fieldNames;

- (NSDictionary *)resultRowAsDictionary;
- (NSArray *)resultRowAsArray;
- (NSArray *)resultAsArray;

- (char **)result;
- (void)setResult:(char **)result;

- (int)resultRows;
- (void)setResultRows:(int)resultRows;

- (int)resultColumns;
- (void)setResultColumns:(int)resultColumns;

- (int)columnCount;
- (void)setColumnCount:(int)columnCount;

- (sqlite3_stmt *)stmtHandler;
- (void)setStmtHandler:(sqlite3_stmt *)stmtHandler;

@end
